/*---------------------------------------------------------------------------
    Copyright 2008 Andrzej Popowski, www.anpo.republika.pl

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
---------------------------------------------------------------------------*/

#define N_VERSION "0.11"

#ifdef NUTRAK_CMD
    #define display_tx printf
    #define TEST_BREAK(x)
#else
    void display_tx(const char *fmt, ...);
    int  test_break(void);
#endif

#define BIT(x) (1 << x)
#define OPT_PRESENT      BIT(0)
#define OPT_ERROR        BIT(1)
#define OPT_SOURCE       BIT(2)
#define OPT_DESTINATION  BIT(3)
#define OPT_COURSE       BIT(4)
#define OPT_MILISEC      BIT(5)
#define OPT_TIME         BIT(6)

struct OPTIONS_STU {
    unsigned        options;
    char            *infile;
    char            *outdir;
    int             tmoff;
};

int nutrak(const char *inpfile, const char *outfile, unsigned opt, int tm);
int parse_arg(int argc, char **argv, OPTIONS_STU *op);
